<?php

return [
    'name' => App\Core\Env::get('APP_NAME', 'OXIRA-MicroMVC'),
    'env' => App\Core\Env::get('APP_ENV', 'production'),
    'debug' => filter_var(App\Core\Env::get('APP_DEBUG', false), FILTER_VALIDATE_BOOLEAN),
    'url' => App\Core\Env::get('APP_URL', ''),
    'timezone' => App\Core\Env::get('APP_TIMEZONE', 'America/Lima'),

    'session' => [
        'name' => App\Core\Env::get('SESSION_NAME', 'OXIRA_SESSID'),
        'lifetime_min' => (int) App\Core\Env::get('SESSION_LIFETIME_MIN', 120),
        'secure' => filter_var(App\Core\Env::get('SESSION_SECURE', false), FILTER_VALIDATE_BOOLEAN),
        'samesite' => App\Core\Env::get('SESSION_SAMESITE', 'Lax'),
    ],

    'csrf' => [
        'enabled' => filter_var(App\Core\Env::get('CSRF_ENABLED', true), FILTER_VALIDATE_BOOLEAN),
    ]
];
