<?php
declare(strict_types=1);

// Paths base
define('BASE_PATH', dirname(__DIR__));
define('APP_PATH', BASE_PATH . '/app');
define('CONFIG_PATH', BASE_PATH . '/config');
define('STORAGE_PATH', BASE_PATH . '/storage');
define('ASSETS_PATH', BASE_PATH . '/assets');

// Autoload simple (sin Composer). Namespace App\* => /app/*
spl_autoload_register(function (string $class): void {
    $prefix = 'App\\';
    if (strncmp($class, $prefix, strlen($prefix)) !== 0) {
        return;
    }
    $relative = substr($class, strlen($prefix));
    $path = APP_PATH . '/' . str_replace('\\', '/', $relative) . '.php';
    if (is_file($path)) {
        require $path;
    }
});

require APP_PATH . '/Core/helpers.php';

// ENV + Config
App\Core\Env::load(BASE_PATH . '/.env');
App\Core\Config::load(CONFIG_PATH);

// Timezone
$tz = App\Core\Config::get('app.timezone', 'America/Lima');
date_default_timezone_set($tz);

// Errores
App\Core\ErrorHandler::register(
    (bool) App\Core\Config::get('app.debug', false),
    STORAGE_PATH . '/logs/app.log'
);

// Sesión
App\Core\Session::start([
    'name' => App\Core\Config::get('app.session.name', 'OXIRA_SESSID'),
    'lifetime_min' => (int) App\Core\Config::get('app.session.lifetime_min', 120),
    'secure' => (bool) App\Core\Config::get('app.session.secure', false),
    'httponly' => true,
    'samesite' => App\Core\Config::get('app.session.samesite', 'Lax'),
]);
