<?php
declare(strict_types=1);

namespace App\Core;

final class Config
{
    private static array $items = [];

    public static function load(string $dir): void
    {
        if (!is_dir($dir)) {
            return;
        }
        $files = glob(rtrim($dir, '/'). '/*.php') ?: [];
        foreach ($files as $file) {
            $key = basename($file, '.php');
            $value = require $file;
            if (is_array($value)) {
                self::$items[$key] = $value;
            }
        }
    }

    public static function get(string $key, $default = null)
    {
        $parts = explode('.', $key);
        $cursor = self::$items;
        foreach ($parts as $part) {
            if (!is_array($cursor) || !array_key_exists($part, $cursor)) {
                return $default;
            }
            $cursor = $cursor[$part];
        }
        return $cursor;
    }
}
