<?php
declare(strict_types=1);

namespace App\Core;

final class Auth
{
    public static function adminCheck(): bool
    {
        return (bool) Session::get('admin_id');
    }

    public static function userCheck(): bool
    {
        return (bool) Session::get('user_id');
    }

    public static function requireAdmin(): void
    {
        if (!self::adminCheck()) {
            \App\Core\redirect('/admin/login');
        }
    }

    public static function requireUser(): void
    {
        if (!self::userCheck()) {
            \App\Core\redirect('/user/login');
        }
    }
}
