<?php
declare(strict_types=1);

namespace App\Core;

final class App
{
    public function run(): void
    {
        $request = new Request();
        $router = new Router();
        $route = $router->resolve($request);

        // Seguridad por área (convención)
        if ($route['area'] === 'admin') {
            // si no es login/logout, exigir admin
            $path = implode('/', $request->segments());
            $isAuthRoute = str_starts_with(strtolower($path), 'admin/login') || str_starts_with(strtolower($path), 'admin/logout');
            if (!$isAuthRoute) {
                Auth::requireAdmin();
            }
        }
        if ($route['area'] === 'user') {
            $path = implode('/', $request->segments());
            $isAuthRoute = str_starts_with(strtolower($path), 'user/login') || str_starts_with(strtolower($path), 'user/logout');
            if (!$isAuthRoute) {
                Auth::requireUser();
            }
        }

        // Cargar controller
        if (!is_file($route['controller_file'])) {
            $this->notFound();
            return;
        }
        require_once $route['controller_file'];

        $class = $route['controller_class'];
        if (!class_exists($class)) {
            $this->notFound();
            return;
        }

        $controller = new $class($request, $route['area']);
        $method = $route['method'];

        if (!method_exists($controller, $method)) {
            $this->notFound();
            return;
        }

        // Ejecutar
        $controller->$method(...$route['params']);
    }

    private function notFound(): void
    {
        http_response_code(404);
        $view = APP_PATH . '/Views/errors/404.php';
        if (is_file($view)) {
            require $view;
            return;
        }
        echo '404 - Not Found';
    }
}
