<?php
declare(strict_types=1);

namespace App\Controllers\Admin\Settings;

use App\Core\Controller;

final class CurrenciesController extends Controller
{
    public function index(): void
    {
        $this->view('settings/currencies/index', [
            'title' => 'Monedas',
            'rows' => [
                ['id' => 1, 'code' => 'PEN', 'name' => 'Sol'],
                ['id' => 2, 'code' => 'USD', 'name' => 'Dólar'],
            ]
        ]);
    }

    public function edit(int $id): void
    {
        $this->view('settings/currencies/edit', [
            'title' => 'Editar moneda',
            'id' => $id,
        ]);
    }
}
