# OXIRA MicroMVC (PHP nativo)

Micro-framework MVC ligero, pensado para hosting compartido:
- `index.php` en raíz (sin `/public`)
- Router automático por convención
- Áreas: `admin`, `user`, `api` (y front por defecto)
- Vistas modulares por área (layout + partials dentro de cada área)
- Configuración por `config/*.php` + secretos/entorno por `.env`

## Instalación rápida
1) Copia el proyecto a tu hosting.
2) Copia `.env.example` a `.env` y ajusta valores.
3) Asegura que Apache tenga `mod_rewrite` activo.
4) Visita `/`.

## Convención de rutas
- `/` => `Controllers/IndexController@index`
- `/news` => `Controllers/NewsController@index`
- `/admin` => `Controllers/Admin/LoginController@index` (si no hay sesión) o `DashboardController@index`
- `/admin/settings/currencies/1/edit` => `Controllers/Admin/Settings/CurrenciesController@edit(1)`
- `/api/ping` => `Controllers/Api/PingController@index`

## Login (demo)
- Admin: `/admin/login`
- User: `/user/login`

> En producción cambia los controladores demo por los tuyos.
